<?php

namespace App\Services;

use App\Models\PortfolioCategory;
use Illuminate\Database\Eloquent\Collection;

class PortfolioCategoryService extends CategoryService
{
    /**
     * Get all categories with project counts
     */
    public function getAllWithProjectCounts(): Collection
    {
        return $this->getAllWithCount(PortfolioCategory::class, 'projects');
    }

    /**
     * Create a new portfolio category
     */
    public function create(array $data): PortfolioCategory
    {
        return $this->createCategory(PortfolioCategory::class, $data);
    }

    /**
     * Update an existing portfolio category
     */
    public function update(PortfolioCategory $category, array $data): PortfolioCategory
    {
        return $this->updateCategory($category, $data);
    }

    /**
     * Delete a portfolio category
     */
    public function delete(PortfolioCategory $category): void
    {
        $this->deleteCategory($category);
    }
}