<?php

namespace App\Services;

use App\Models\HeroImage;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
class HeroImageService extends BaseService
{
    public function getAllHeroImages(): Collection
    {
        return HeroImage::orderBy('display_order')->get();
    }

    public function getActiveHeroImages(): Collection
    {
        return HeroImage::where('is_active', true)
            ->orderBy('display_order')
            ->get();
    }

    public function createHeroImage(array $data): HeroImage
    {
        $dataHeroImage['image_url'] = $this->uploadFile($data['image'], 'hero-images');
        // if mobile_image is not null, upload it
        if (isset($data['mobile_image'])) {
            $dataHeroImage['mobile_image_url'] = $this->uploadFile($data['mobile_image'], 'hero-images');
        }
        $dataHeroImage['alt_text'] = $data['alt_text'] ?? null;
        $dataHeroImage['title'] = $data['title'] ?? null;
        $dataHeroImage['subtitle'] = $data['subtitle'] ?? null;
        $dataHeroImage['cta_text'] = $data['cta_text'] ?? null;
        $dataHeroImage['cta_link'] = $data['cta_link'] ?? null;
        $dataHeroImage['display_order'] = $data['display_order'] ?? 0;
        $dataHeroImage['is_active'] = isset($data['is_active']) ? true : false;
        $dataHeroImage['start_date'] = isset($data['start_date']) ? $data['start_date'] : null;
        $dataHeroImage['end_date'] = isset($data['end_date']) ? $data['end_date'] : null;
        $heroImage = HeroImage::create($dataHeroImage);
        // return the hero image
        return $heroImage;
    }

    public function updateHeroImage(HeroImage $heroImage, array $data): HeroImage
    {
        if (isset($data['image'])) {
            $dataHeroImage['image_url'] = $this->uploadFile($data['image'], 'hero-images', $heroImage->image_url);
        }
        // if mobile_image is not null, upload it
        if (isset($data['mobile_image'])) {
            $dataHeroImage['mobile_image_url'] = $this->uploadFile($data['mobile_image'], 'hero-images');
        }
        $dataHeroImage['alt_text'] = $data['alt_text'] ?? null;
        $dataHeroImage['title'] = $data['title'] ?? null;
        $dataHeroImage['subtitle'] = $data['subtitle'] ?? null;
        $dataHeroImage['cta_text'] = $data['cta_text'] ?? null;
        $dataHeroImage['cta_link'] = $data['cta_link'] ?? null;
        $dataHeroImage['display_order'] = $data['display_order'] ?? 0;
        $dataHeroImage['is_active'] = isset($data['is_active']) ? true : false;
        $dataHeroImage['start_date'] = isset($data['start_date']) ? $data['start_date'] : null;
        $dataHeroImage['end_date'] = isset($data['end_date']) ? $data['end_date'] : null;
        $heroImage->update($dataHeroImage);
        // return the hero image
        return $heroImage->fresh();
    }

    public function deleteHeroImage(HeroImage $heroImage): void
    {
        $heroImage->delete();
    }
}