<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PortfolioProjectResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'slug' => $this->slug,
            'description' => $this->description,
            'thumbnail' => getFileUrl($this->thumbnail),
            'category' => new PortfolioCategoryResource($this->whenLoaded('category')),
            'images' => ProjectImageResource::collection($this->whenLoaded('images')),
            'features' => $this->features->map(function ($feature) {
                return [
                    'feature' => $feature->feature,
                    'description' => $feature->description,
                ];
            }),
            'why_choose_us' => $this->whyChooseUs->map(function ($whyChooseUs) {
                return [
                    'title' => $whyChooseUs->title,
                    'description' => $whyChooseUs->description,
                ];
            }),
            'testimonials' => $this->testimonials->map(function ($testimonial) {
                return [
                    'id' => $testimonial->id,
                    'name' => $testimonial->name,
                    'position' => $testimonial->position,
                    'avatar' => getFileUrl($testimonial->avatar),
                    'content' => $testimonial->content,
                ];
            }),
            'is_active' => $this->is_active,
            'order' => $this->order,
            'detail_features' => $this->detail_features,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
