<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OurClientResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'logo_url' => getFileUrl($this->logo_path),
            'display_order' => $this->display_order,
            'is_active' => $this->is_active,
            'website_url' => $this->website_url,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}