<?php

namespace App\Http\Requests\Portfolio;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => 'sometimes|required|string|max:200',
            'description' => 'nullable|string',
            'thumbnail' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'category_id' => 'sometimes|required|exists:portfolio_categories,id',
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'The project title is required',
            'title.max' => 'The project title cannot exceed 200 characters',
            'thumbnail.image' => 'The thumbnail must be an image file',
            'category_id.required' => 'Please select a category',
            'category_id.exists' => 'The selected category does not exist',
        ];
    }
} 