<?php

namespace App\Http\Requests\Article;

use Illuminate\Foundation\Http\FormRequest;

class StoreArticleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'author' => 'required|string|max:255',
            'category_id' => 'nullable|exists:article_categories,id',
            'excerpt' => 'nullable|string',
            'published_at' => 'nullable|date',
            'is_featured' => 'nullable|boolean',
            'is_active' => 'nullable|boolean',
            'slug' => 'nullable|string|unique:articles,slug'
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'The article title is required',
            'title.max' => 'The article title cannot exceed 255 characters',
            'content.required' => 'The article content is required',
            'image.required' => 'An article image is required',
            'image.image' => 'The file must be an image',
            'author.required' => 'The author name is required',
            'category_id.exists' => 'The selected category does not exist',
            'slug.unique' => 'This slug is already in use'
        ];
    }
} 