<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\Hero\StoreHeroImageRequest;
use App\Http\Requests\Hero\UpdateHeroImageRequest;
use App\Http\Resources\HeroImageResource;
use App\Services\HeroImageService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use App\Models\HeroImage;

class HeroImageController extends Controller
{
    protected $heroImageService;

    public function __construct(HeroImageService $heroImageService)
    {
        $this->heroImageService = $heroImageService;
    }

    public function index(): AnonymousResourceCollection
    {
        $heroImages = $this->heroImageService->getAllHeroImages();
        return HeroImageResource::collection($heroImages);
    }

    public function store(StoreHeroImageRequest $request): HeroImageResource
    {
        $heroImage = $this->heroImageService->createHeroImage($request->validated());
        return new HeroImageResource($heroImage);
    }

    public function show(HeroImage $heroImage): HeroImageResource
    {
        return new HeroImageResource($heroImage);
    }

    public function update(UpdateHeroImageRequest $request, HeroImage $heroImage): HeroImageResource
    {
        $heroImage = $this->heroImageService->updateHeroImage($heroImage, $request->validated());
        return new HeroImageResource($heroImage);
    }

    public function destroy(HeroImage $heroImage): JsonResponse
    {
        $this->heroImageService->deleteHeroImage($heroImage);
        return response()->json(null, 204);
    }
}
