<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;
use App\Models\Article;
use App\Models\Service;
use App\Models\PortfolioProject;
use App\Models\Contact;

class DashboardController extends Controller
{
    use ApiResponse;

    public function dashboard()
    {
        try {
            $data = [
                'total_articles' => Article::count(),
                'total_services' => Service::count(),
                'total_portfolio_projects' => PortfolioProject::count(),
                'total_contacts' => Contact::count(),
                'unread_contacts' => Contact::where('is_read', false)->count()
            ];

            return $this->successResponse($data);
        } catch (\Exception $e) {
            return $this->errorResponse('Error fetching dashboard data: ' . $e->getMessage());
        }
    }
}