<?php

namespace App\Services;

use App\Models\Service;
use Illuminate\Database\Eloquent\Collection;

class ServiceService extends BaseService
{

    public function getAllActive(): Collection
    {
        return Service::active()->ordered()->get();
    }


    public function create(array $data): Service
    {
        // if (isset($data['icon'])) {
        //     $data['icon'] = $this->uploadFile($data['icon'], 'services');
        // }

        return Service::create($data);
    }


    public function update(Service $service, array $data): Service
    {
        // if (isset($data['icon'])) {
        //     $this->deleteFile($service->icon);
        //     $data['icon'] = $this->uploadFile($data['icon'], 'services');
        // }

        $service->update($data);
        return $service;
    }


    public function delete(Service $service): void
    {
        $this->deleteFile($service->icon);
        $service->delete();
    }
}