<?php

namespace App\Services;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

abstract class BaseService
{
    /**
     * Upload a file and return its path
     */
    protected function uploadFile(UploadedFile $file, $path = '', $previousPath = ''): string
    {
        $path = 'uploads/' . $path;
        $filename = $this->generateFileName($file);
        $filePath = $path ? $path . '/' . $filename : $filename;

        if (!file_exists(public_path($path))) {
            mkdir(public_path($path), 0777, true);
        }

        if ($previousPath) {
            $this->deleteFile($previousPath);
        }

        $file->move(public_path($path), $filename);

        return $filePath;
    }

    /**
     * Generate a file Name
     */
    protected function generateFileName(UploadedFile $file): string
    {
        return Str::random(40) . '.' . $file->getClientOriginalExtension();
    }

    /**
     * Delete a file from storage
     */
    public function deleteFile($path): bool
    {
        $file = '';
        if ($path) {
            $previousImagePath = public_path($path);
            if (File::exists($previousImagePath)) {
                $file = File::delete($previousImagePath);
            }
        }
        return $file;
    }

    public function getUrl($path): string
    {
        return asset($path);
    }
}