<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class PortfolioCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug'
    ];

    protected static function boot()
    {
        parent::boot();
        
        // Automatically generate slug when creating
        static::creating(function ($portfolioCategory) {
            if (empty($portfolioCategory->slug)) {
                $portfolioCategory->slug = Str::slug($portfolioCategory->name);
            }
        });

        // Update slug when name changes
        static::updating(function ($portfolioCategory) {
            if ($portfolioCategory->isDirty('name')) { // Check if name has changed
                $portfolioCategory->slug = Str::slug($portfolioCategory->name);
            }
        });
    }

    public function projects()
    {
        return $this->hasMany(PortfolioProject::class, 'category_id');
    }
}
