<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyContentBlock extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_information_id',
        'heading',
        'content',
        'display_order',
        'image_position'
    ];


    public function companyInformation()
    {
        return $this->belongsTo(CompanyInformation::class, 'company_information_id');
    }

    public function images()
    {
        return $this->hasMany(CompanyContentBlockImage::class, 'content_block_id')
                    ->orderBy('display_order', 'asc');
    }
}
