<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class ArticleCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'description'
    ];

    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($articleCategory) {
            if (empty($articleCategory->slug)) {
                $articleCategory->slug = Str::slug($articleCategory->name);
            }
        });

        static::updating(function ($articleCategory) {
            if ($articleCategory->isDirty('name')) {
                $articleCategory->slug = Str::slug($articleCategory->name);
            }
        });
    }

    public function articles()
    {
        return $this->hasMany(Article::class, 'category_id');
    }
} 