<?php

namespace App\Http\Requests\Portfolio;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCategoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:50',
            'slug' => 'nullable|string|max:50|unique:portfolio_categories,slug,' . $this->portfolioCategory->id
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'The category name is required',
            'name.max' => 'The category name cannot exceed 50 characters',
            'slug.unique' => 'This slug is already in use',
            'slug.max' => 'The slug cannot exceed 50 characters'
        ];
    }
} 